// Copyright 2000, 2001, 2002, 2003 Macromedia, Inc. All rights reserved.

	function receiveArguments()
	{
		var itemID = arguments[0];
		var scope = arguments[1];
		var docPath = (scope == 'site') ? "site" : dw.getDocumentPath('document');

		if (itemID == "unlock")
		{
			if (scope == 'document')
			{
				dw.getDocumentDOM().makeEditable();
			}
			else
			{
				site.makeEditable();
			}
		}
		else if (itemID == "connect")
		{
			site.setConnectionState(!site.getConnectionState());
		}
		else if (itemID == "sethomepage")
		{
			site.setAsHomePage();
		}
		else if (itemID == "put")
		{
			site.put(docPath);
		}
		else if (itemID == "get")
		{
			site.get(docPath);
		}
		else if (itemID == "checkout")
		{
			site.checkOut(docPath);
		}
		else if (itemID == "checkin")
		{
			site.checkIn(docPath);
		}
		else if (itemID == "undocheckout")
		{
			site.undoCheckOut(docPath);
		}
		else if (itemID == "findlocal")
		{
			site.locateInSite("local", docPath);
		}
		else if (itemID == "findremote")
		{
			site.locateInSite("remote", docPath);
		}
		else if (itemID == "findlocalremote")
		{
			site.locateInSite(site.getFocus(), docPath);
		}
		else if (itemID == "togglemap")
		{
			dw.toggleFloater('site map');
		}
   }

   function canAcceptCommand()
   {
		var itemID = arguments[0];
		var scope = arguments[1];
		var docPath = (scope == 'site') ? "site" : dw.getDocumentPath('document');

		if (itemID == "unlock")
		{
			if (scope == 'document')
			{
				return dw.getDocumentDOM().canMakeEditable();
			}
			else
			{
				return site.canMakeEditable();
			}
		}
		else if (itemID == "connect")
		{
			return ((scope != 'document') && site.canConnect());
		}
		else if (itemID == "sethomepage")
		{
			if (site.getSelection().length == 1)
			{
				var urlPrefix = "file:///";
				var strTemp = site.getSelection()[0].substr(urlPrefix.length);
				
				if (strTemp.indexOf("/") == (-1))
					return false;
				
				if ((DWfile.getAttributes(site.getSelection()[0]) == null) ||
					(DWfile.getAttributes(site.getSelection()[0]).indexOf('D') == (-1)))
				{
					return true;
				}
			}
			
			return false;
		}
		else if (itemID == "put")
		{
			return site.canPut(docPath);
		}
		else if (itemID == "get")
		{
			return site.canGet(docPath);
		}
		else if (itemID == "checkout")
		{
			return site.canCheckOut(docPath);
		}
		else if (itemID == "checkin")
		{
			return site.canCheckIn(docPath);
		}
		else if (itemID == "undocheckout")
		{
			return site.canUndoCheckOut(docPath);
		}
		else if (itemID == "findlocal")
		{
			return site.canLocateInSite("local", docPath);
		}
		else if (itemID == "findremote")
		{
			return site.canLocateInSite("remote", docPath);
		}
		else if (itemID == "findlocalremote")
		{
			return site.canLocateInSite(site.getFocus(), docPath);
		}
		
		return true;
   }

   function setMenuText()
   {
		var itemID = arguments[0];
 		
 		if (itemID == "connect")
		{
			if (site.getConnectionState() == true)
			{
				return MENU_Disconnect;
			}
			else
			{
				return MENU_Connect;
			}
		}
		else if (itemID == "togglemap")
		{
			if (dw.getFloaterVisibility("site map"))
			{
				return MENU_SiteFiles;
			}
			else
			{
				return MENU_SiteMap;
			}
		}
		
		return "";
   }
   